/*
 * --COPYRIGHT--,BSD Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved. Redistribution and use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met: * Redistributions of source code must
 * retain the above copyright notice, this list of conditions and the
 * following disclaimer. * Redistributions in binary form must reproduce
 * the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with
 * the distribution. * Neither the name of Texas Instruments Incorporated 
 * nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE. --/COPYRIGHT--
 */

/*******************************************************************************
 *
 *  utility.h - Definition file for utility functions
 *
 ******************************************************************************/

#ifndef UTILITY_H_
#define UTILITY_H_

/*****************************************************************************/

// change to reflect firmware revision
#define FW_VERSION 1.0		// uses utility_v0p2.c
// count to toggle status LED and force update
#define LED_TIMEOUT 6000

// 
#define	DEFAULT_IFS				0
#define	DEFAULT_SENSE_RESISTOR	0.25
#define	DEFAULT_VREF_VAL		300
#define V3P3_TIMES_GAIN         0.5	// 3.3 divide by 6.6, use constant
#define	DEFAULT_TORQUE			0	// 100% (use index value 0 
						// - 3)
#define DEFAULT_DECAY			2	// mixed decay


// IFS defines
// this are used to calculate the chopping current
#define V3P3_TIMES_GAIN			0.5	// 3.3 divide by 6.6, use
						// constant
#define VREF_BIT				0.0009775	// 1/1023
								// per
								// step
#define TORQUE_STEP				0.25	// 1/4 per step


// GPIO Port Definitions



// GPIO Port 2 Definitions
#define BDECAY		BIT0	// P2.0
#define ADECAY		BIT1	// P2.1
#define AIN2		BIT4	// P2.4
#define TOFF		BIT7	// P2.7
#define TRQ1		BIT2	// P2.2
#define TRQ0		BIT5	// P2.5
#define AIN1		BIT3	// P2.3
#define PARA		BIT6	// P2.6

#define CAPD_BDECAY BIT0
#define CAPD_ADECAY BIT1
#define CAPD_TRQ1	BIT2
#define CAPD_TRQ0	BIT5
#define CAPD_TOFF	BIT7
#define CAPD_AIN1	BIT3
#define CAPD_PARA	BIT6

// GPIO Port 4 Definitions
#define WAKE		BIT5	// P4.5
#define BIN1		BIT2	// P4.2
#define BIN2		BIT1	// P4.1
#define FAULT		BIT6	// P4.6
#define V3P3_GPIO   BIT7	// P4.7

// GPIO Port 6 Definitions
#define AVREF       BIT6	// P6.6 ***
#define BVREF		BIT6	// P6.6 ****BVREF
#define STATUS		BIT5	// P6.5

// 
// defines to make code more readable, and easier to fix
// 

#define toggle_status_led 		P6OUT ^=  STATUS

#define set_BDECAY_hi			P2OUT |=  BDECAY
#define set_BDECAY_lo			P2OUT &= ~BDECAY
#define set_ADECAY_hi			P2OUT |=  ADECAY
#define set_ADECAY_lo			P2OUT &= ~ADECAY

#define set_DIR_hi				P4OUT |=  DIR
#define set_DIR_lo				P4OUT &= ~DIR

#define set_ENABLE_hi			P4OUT |=  ENABLE
#define set_ENABLE_lo			P4OUT &= ~ENABLE

#define set_TOFF_hi				P2OUT |=  TOFF
#define set_TOFF_lo				P2OUT &= ~TOFF

#define set_TRQ1_hi				P2OUT |=  TRQ1
#define set_TRQ1_lo				P2OUT &= ~TRQ1
#define set_TRQ0_hi				P2OUT |=  TRQ0
#define set_TRQ0_lo				P2OUT &= ~TRQ0

#define set_AIN1_hi				P2OUT |=  AIN1
#define set_AIN1_lo				P2OUT &= ~AIN1
#define set_PARA_hi				P2OUT |=  PARA
#define set_PARA_lo				P2OUT &= ~PARA

#define set_WAKE_hi				P4OUT |=  WAKE
#define set_WAKE_lo				P4OUT &= ~WAKE

#define enable_V3P3_GPIO		P4OUT |= V3P3_GPIO; P4DIR |=  V3P3_GPIO
#define disable_V3P3_GPIO		P4DIR &= ~V3P3_GPIO

// enable/disable output

#define enable_BDECAY_output	P2DIR |=  BDECAY
#define disable_BDECAY_output	P2DIR &= ~BDECAY
#define enable_ADECAY_output	P2DIR |=  ADECAY
#define disable_ADECAY_output	P2DIR &= ~ADECAY

#define disable_BDECAY_input	CAPD  |=  CAPD_BDECAY
#define enable_BDECAY_input		CAPD  &= ~CAPD_BDECAY
#define disable_ADECAY_input	CAPD  |=  CAPD_ADECAY
#define enable_ADECAY_input		CAPD  &= ~CAPD_ADECAY

#define enable_TOFF_output		P2DIR |=  TOFF
#define disable_TOFF_output		P2DIR &= ~TOFF

#define disable_TOFF_input		CAPD  |=  CAPD_TOFF
#define enable_TOFF_input		CAPD  &= ~CAPD_TOFF

#define enable_AIN1_output		P2DIR |=  AIN1
#define disable_AIN1_output		P2DIR &= ~AIN1
#define enable_PARA_output		P2DIR |=  PARA
#define disable_PARA_output		P2DIR &= ~PARA

#define disable_AIN1_input		CAPD  |=  CAPD_AIN1
#define enable_AIN1_input		CAPD  &= ~CAPD_AIN1
#define disable_PARA_input		CAPD  |=  CAPD_PARA
#define enable_PARA_input		CAPD  &= ~CAPD_PARA

#define read_FAULT_pin			(P4IN & FAULT)

#define disable_ENABLE_output   P4DIR &= ~ENABLE
#define enable_ENABLE_output    P4DIR |= ENABLE

// Custom Types
typedef enum { false, true } boolean;
typedef enum { low, high } gpio;

/*****************************************************************************/

// Declare Global Variables

// ***********************************************************************************
// Global Variables for GUI Composer *
// ***********************************************************************************
extern unsigned int G_PWM_AIN1;
extern unsigned int G_PWM_AIN2;
extern unsigned int G_PWM_BIN1;
extern unsigned int G_PWM_BIN2;

extern unsigned int G_Normal_A;
extern unsigned int G_Normal_B;
extern unsigned int G_Parallel;
extern unsigned int G_Stepper;

// GPIO
extern gpio     G_WAKE;		// Wake device 0 - Sleep 1 - Wake
extern gpio     G_DIRECTION;	// Direction 0 - Forward 1 - Reverse
extern gpio     G_FAULT;	// Fault Status 0 - Fault 1 - OK
extern gpio     G_RUN;

extern unsigned int G_Mode;

// PWM Generation

extern unsigned long G_AVREF_VAL;	// scale for current
extern unsigned long G_BVREF_VAL;	// scale for current
extern unsigned int G_PPS_Value;
extern unsigned int G_TORQUE;	// Torque (1 of 4)
extern unsigned int G_TOFF;	// PWM off time (1 of 3)

extern float    G_AVREF;	// VREF
extern float    G_AIFS;		// Full scale current
extern float    G_BVREF;	// VREF
extern float    G_BIFS;		// Full scale current
extern float    G_IRSENSE;	// sense value resistor
extern unsigned int G_ADECAY;	// ADECAY (1 of 3)
extern unsigned int G_BDECAY;	// BDECAY (1 of 3)
extern float    G_FIRMWARE_VERSION;	// keep track of firmware

float           vref_times_irsense_times_constant;
float           torque_multiplier;
float           avref_multiplier;
float           bvref_multiplier;
float           step_multiplier;
float           irsense_multiplier;

boolean         UpdateChoppingCurrentA;
boolean         UpdateChoppingCurrentB;

// use 0/1 and shift by this value when
// necessary
unsigned int    LED_TOGGLE_CNT;	// count to determine if LED should be
				// toggled

/*****************************************************************************/
// Function Declarations

// Main Functions
void            Initialize();
void            UpdateSystem();

// GPIO/GUI Functions
void            SetDefaultGUIVals();
void            SetDefaultGPIOVals();


#endif				/* UTILITY_H_ */
